/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.block;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.tileentity.BoostTileEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import com.mrcrayfish.vehicle.util.StateHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockBoostPad
extends BlockRotatedObject {
    public static final BooleanProperty LEFT = BooleanProperty.func_177716_a((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.func_177716_a((String)"right");
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockBoostPad() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(0.6f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)DIRECTION, (Comparable)Direction.NORTH)).func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            tooltip.addAll(RenderUtil.lines((ITextProperties)new TranslationTextComponent(this.func_149739_a() + ".info"), 150));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0])));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        Direction facing;
        if (entityIn instanceof PoweredVehicleEntity && entityIn.func_184179_bs() != null && (facing = (Direction)state.func_177229_b((Property)DIRECTION)) == entityIn.func_174811_aO()) {
            PoweredVehicleEntity poweredVehicle;
            float speedMultiplier = 0.0f;
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof BoostTileEntity) {
                speedMultiplier = ((BoostTileEntity)tileEntity).getSpeedMultiplier();
            }
            if (!(poweredVehicle = (PoweredVehicleEntity)entityIn).isBoosting()) {
                worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.BOOST_PAD.get(), SoundCategory.BLOCKS, 1.0f, 0.5f);
            }
            poweredVehicle.setBoosting(true);
            poweredVehicle.currentSpeed = poweredVehicle.getActualMaxSpeed();
            poweredVehicle.speedMultiplier = speedMultiplier;
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos pos, BlockPos facingPos) {
        return this.getBoostPadState(state, (Direction)state.func_177229_b((Property)DIRECTION), worldIn, pos);
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getBoostPadState(super.func_196258_a(context), context.func_195992_f(), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private BlockState getBoostPadState(BlockState state, Direction direction, IWorld world, BlockPos pos) {
        if (StateHelper.getBlock((IWorldReader)world, pos, direction, StateHelper.RelativeDirection.LEFT) == this && StateHelper.getRotation((IWorldReader)world, pos, direction, StateHelper.RelativeDirection.LEFT) == StateHelper.RelativeDirection.DOWN) {
            state = (BlockState)state.func_206870_a((Property)RIGHT, (Comparable)Boolean.valueOf(true));
        }
        if (StateHelper.getBlock((IWorldReader)world, pos, direction, StateHelper.RelativeDirection.RIGHT) == this && StateHelper.getRotation((IWorldReader)world, pos, direction, StateHelper.RelativeDirection.RIGHT) == StateHelper.RelativeDirection.DOWN) {
            state = (BlockState)state.func_206870_a((Property)LEFT, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LEFT});
        builder.func_206894_a(new Property[]{RIGHT});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BoostTileEntity(0.5f);
    }
}

